#!/bin/bash

DIR_RSA=/srv/EasyRSA-3.0.8
DIR_CLI=/srv/client-configs
KEY_DIR=${DIR_CLI}/keys
OUTPUT_DIR=${DIR_CLI}/files
BASE_CONFIG=${DIR_CLI}/base.conf


if [ -z ${1} ];
then
echo Нужно запускать скрипт с параметром имя создаваемого клиента
else
cd ${DIR_RSA}
./easyrsa build-client-full ${1} nopass
cp ./pki/private/${1}.key ${DIR_CLI}/keys/
#./easyrsa import-req ./pki/reqs/$1.req $1
#./easyrsa sign-req client $1
cp ./pki/issued/${1}.crt ${DIR_CLI}/keys/

cat ${BASE_CONFIG} \
    <(echo -e '\n<ca>') \
    ${KEY_DIR}/ca.crt \
    <(echo -e '</ca>\n<cert>') \
    ${KEY_DIR}/${1}.crt \
    <(echo -e '</cert>\n<key>') \
    ${KEY_DIR}/${1}.key \
    <(echo -e '</key>\n<tls-auth>') \
    ${KEY_DIR}/ta.key \
    <(echo -e '</tls-auth>') \
    > ${OUTPUT_DIR}/${1}.ovpn
echo "Забери свое гавно тут: ${OUTPUT_DIR}/"
fi
