#!/bin/bash

DIR_RSA=/srv/EasyRSA-3.0.8
DIR_CLI=/srv/client-configs
KEY_DIR=${DIR_CLI}/keys
OUTPUT_DIR=${DIR_CLI}/files
BASE_CONFIG=${DIR_CLI}/base.conf

echo "Укажите название конфига"
read config_name
if [ -z ${config_name} ];
then
echo Нужно запускать скрипт с параметром имя создаваемого клиента
else
cd ${DIR_RSA}
./easyrsa build-client-full ${config_name} nopass
cp ./pki/private/${config_name}.key ${DIR_CLI}/keys/
#./easyrsa import-req ./pki/reqs/$1.req $1
#./easyrsa sign-req client $1
cp ./pki/issued/${config_name}.crt ${DIR_CLI}/keys/

cat ${BASE_CONFIG} \
    <(echo -e '\n<ca>') \
    ${KEY_DIR}/ca.crt \
    <(echo -e '</ca>\n<cert>') \
    ${KEY_DIR}/${config_name}.crt \
    <(echo -e '</cert>\n<key>') \
    ${KEY_DIR}/${config_name}.key \
    <(echo -e '</key>\n<tls-auth>') \
    ${KEY_DIR}/ta.key \
    <(echo -e '</tls-auth>') \
    > ${OUTPUT_DIR}/${config_name}.ovpn
echo "Zaberi svoe gavno tyt: ${OUTPUT_DIR}/"
fi
