terraform {
  required_providers {
    digitalocean = {
      source  = "digitalocean/digitalocean"
      version = "~> 2.0"
    }
    aws       = {
      source  = "hashicorp/aws"
      version = "~> 3.0"
    }
  }
}

# token auntithication DO
provider "digitalocean" {
  token       = var.api_token
}

# auntithication AWS
provider "aws" {
  region      = "us-west-2"
  access_key  = var.access-key
  secret_key  = var.secret-key
}

# Get ssh key from account
data "digitalocean_ssh_key" "rebrain_key" {
  name        = "REBRAIN.SSH.PUB.KEY"
}

# Add my ssh key
resource "digitalocean_ssh_key" "My" {
  name        = "my_public_key"
  public_key  = var.my_public_key
}

# Generate random password for droplets
resource "random_string" "password" {
  count       = "${length(var.devs)}"
  length      = "10"
  upper       = true
  lower       = true
  number      = true
  special     = false
}

# Create VM (droplet) with ssh_keys
resource "digitalocean_droplet" "VPS" {
  count       = "${length(var.devs)}"
  image       = "ubuntu-18-04-x64"
  name        = "${element(var.devs, count.index)}"
  region      = "nyc3"
  size        = "s-1vcpu-1gb"
  tags        = ["devops","trofimov-yaroslav_at_mail_ru"]
  ssh_keys    = [data.digitalocean_ssh_key.rebrain_key.id, digitalocean_ssh_key.My.id]


  # Change user password in VM 
  provisioner "remote-exec" {
    inline    = [
      "/bin/echo -e '${element(random_string.password.*.result, count.index)}\n${element(random_string.password.*.result, count.index)}\n' | /usr/bin/passwd"
    ]
  connection {
    type      = "ssh"
    user      = "root" 
    private_key = file(var.private_key) 
    host      = self.ipv4_address
    timeout   = "2m"
    }
  }
}

# get zone_id 
data "aws_route53_zone" "zone1" {
   name       = "devops.rebrain.srwx.net"
}


# Create new resource DNS record type A
resource "aws_route53_record" "dns_records_DO" {
  count       = length(var.devs)
  zone_id     = data.aws_route53_zone.zone1.zone_id
  name        = "${element(var.devs, count.index)}.${data.aws_route53_zone.zone1.name}"
  type        = "A"
  ttl         = 300
  records     = ["${element(digitalocean_droplet.VPS.*.ipv4_address, count.index)}"]
  allow_overwrite  = true
}



data "template_file" "template1" {
  template    = file("${path.module}/template1.tpl")
  count       = "${length(var.devs)}"
  vars        = {
    host      = aws_route53_record.dns_records_DO[count.index].name 
  }
}


resource "local_file" "report" {
    content   = join("", data.template_file.template1.*.rendered)
    filename  = "inventory.yml"
}


